<?php

//============================================================================================================//
//== NOTE: When the HTTP Parameter called 'Type'
//== If it is set as 'all' it will just load everything it can in to the XML files.
//== If it is set to a property type then it only loads a single property of that type into the XML file.
//============================================================================================================//

//================================================================================//
//== SiteBase & Required Classes
//================================================================================//

if (!defined('SITE_BASE')) {
	@define('SITE_BASE', dirname(__FILE__));
}

//-- Load Required Classes --//
require_once( SITE_BASE."/_Manager.class.php" );


//================================================================================//
//== Execute REAXML_Manager XML Build & Save
//================================================================================//
//--------------------------------------------------------//
//-- Config Placeholder
//--------------------------------------------------------//
$mConfig = array('bDebugging'=>false);
//-- Load the Real Config --//
require_once( SITE_BASE."/_Config.php" );


//--------------------------------------------------------//
//-- Load Type to find
//--------------------------------------------------------//
$bParamFoundGet  = false;
$bParamFoundPost = false;
//$bParamIsValid   = false;
$sParamType      = "";


if( isset( $_POST['Type'] ) ) {
	$bParamFoundPost = true;
	$sParamType      = $_POST['Type'];
} else if( isset( $_GET['Type'] ) ) {
	$bParamFoundGet  = true;
	$sParamType      = $_GET['Type'];
}



if( $bParamFoundPost===false && $bParamFoundGet===false ) {
	$sParamType = "All";
	//echo "HTTP POST 'Type' Parameter not Found!";
	//die();
}


if( !is_string( $sParamType ) || strlen( $sParamType )<3 ) {
	echo "Invalid 'Type' Parameter!";
	die();
}


//if( $sParamType!=="All" ) {
//    echo "Disabled";
//    die();
//}


//--------------------------------------------------------//
//-- Start building the XML
//--------------------------------------------------------//
echo "Starting XML convert at ".time()."!\n<br />\n";
$XMLParser = new REAXML_Manager( $mConfig );

try {
	//================================================================================//
	//== IF ParamType = All
	//================================================================================//
	if( $sParamType==="All" ) {
		$XMLParser->BuildXML_All();
		
	//================================================================================//
	//== ELSE
	//================================================================================//
	} else {
		$bResult = $XMLParser->BuildXMLForType( $sParamType );
		
		if( $bResult ) {
			echo "Converted the file of type '".$sParamType."'.<br />\n";
		} else {
			echo "No new files found of that type.<br />\n";
		}
	}
	
	
	echo "Completed at ".time()."!";
		
} catch( \Error $e ) {
	echo "An issue occurred preventing the API from completing!<br />\n";
	echo $e->getMessage();
	die();
	
} catch( \Exception $e ) {
	echo "Unexpected Issue!<br />\n";
	die();
}


try {
	if( $mConfig['bDebugging']===true ) {
		echo "<br />\n== Debugging ==<br />\n";
		foreach( $XMLParser->aDebugLog as $sDebugLogEntry ) {
			echo $sDebugLogEntry." <br />\n";
		}
	}
} catch( \Exception $e ) {
	
}