<?php

//================================================================================//
//== SITEBASE & Required Classes
//================================================================================//
if (!defined('SITE_BASE')) {
	@define('SITE_BASE', dirname(__FILE__));
}
//-- Load Required Classes --//
require_once( SITE_BASE."/_Manager.class.php" );

//================================================================================//
//== Declare Functions
//================================================================================//
function DebugTime( $iStartMinute, $iHourMod ){
	echo "<br />\nStartMin=".$iStartMinute." HourMod=".$iHourMod." &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".REAXML_Manager::DateTimeStringFromMinuteAndHourMod( $iStartMinute, $iHourMod );
}

//-- Residential --//
function RunImport_Resi( &$aReturn, &$aImportQueue, &$bResi, &$iHourResi, $iStartMin ) {
	if( isset( $aImportQueue['residential'] ) && count( $aImportQueue['residential'] ) ) {
		$bResi     = true;
		$mCurProp  = array_shift( $aImportQueue['residential'] );
		//$iStartMin = REAXML_Manager::START_MIN_RES1;
		$mCurProp['Schedule'] = REAXML_Manager::DateTimeStringFromMinuteAndHourMod( $iStartMin, $iHourResi );
		$aReturn[]  = $mCurProp;
		$iHourResi++;
	}
}

//-- Commercial --//
function RunImport_Comm( &$aReturn, &$aImportQueue, &$bComm, &$iHourComm ) {
	if( isset( $aImportQueue['commercial'] ) && count( $aImportQueue['commercial'] ) ) {
		$bComm    = true;
		$mCurProp = array_shift( $aImportQueue['commercial'] );
		$mCurProp['Schedule'] = REAXML_Manager::DateTimeStringFromMinuteAndHourMod( REAXML_Manager::START_MIN_COMM, $iHourComm );
		$aReturn[] = $mCurProp;
		$iHourComm++;
	}
}

//-- Land --//
function RunImport_Land( &$aReturn, &$aImportQueue, &$bLand, &$iHourLand ) {
	if( isset( $aImportQueue['land'] ) && count( $aImportQueue['land'] ) ) {
		$bLand    = true;
		$mCurProp = array_shift( $aImportQueue['land'] );
		$mCurProp['Schedule'] = REAXML_Manager::DateTimeStringFromMinuteAndHourMod( REAXML_Manager::START_MIN_LAND, $iHourLand );
		
		$aReturn[] = $mCurProp;
		$iHourLand++;
	}
}

//-- Rental --//
function RunImport_Rent( &$aReturn, &$aImportQueue, &$bRent, &$iHourRent ) {
	if( isset( $aImportQueue['rental'] ) && count( $aImportQueue['rental'] ) ) {
		$bRent    = true;
		$mCurProp = array_shift( $aImportQueue['rental'] );
		$mCurProp['Schedule'] = REAXML_Manager::DateTimeStringFromMinuteAndHourMod( REAXML_Manager::START_MIN_RENT, $iHourRent );
		
		$aReturn[] = $mCurProp;
		$iHourRent++;
	}
}

//-- Rural --//
function RunImport_Rura( &$aReturn, &$aImportQueue, &$bRural, &$iHourRural ) {
	if( isset( $aImportQueue['rural'] ) && count( $aImportQueue['rural'] ) ) {
		$bRural   = true;
		$mCurProp = array_shift( $aImportQueue['rural'] );
		$mCurProp['Schedule'] = "Never";

		$aReturn[] = $mCurProp;
		$iHourRural++;
	}
}

function RunImport_ComL( &$aReturn, &$aImportQueue, &$bComLand, &$iHourComLand ) {
	if( isset( $aImportQueue['commercialland'] ) && count( $aImportQueue['commercialland'] ) ) {
		$bComLand   = true;
		$mCurProp = array_shift( $aImportQueue['commercialland'] );
		$mCurProp['Schedule'] = "Never";

		$aReturn[] = $mCurProp;
		$iHourComLand++;
	}
}

function RunImport_HolR( &$aReturn, &$aImportQueue, &$bHolidayRental, &$iHourHolidayRental ) {
	if( isset( $aImportQueue['holidayrental'] ) && count( $aImportQueue['holidayrental'] ) ) {
		$bHolidayRental   = true;
		$mCurProp = array_shift( $aImportQueue['holidayrental'] );
		$mCurProp['Schedule'] = "Never";

		$aReturn[] = $mCurProp;
		$iHourHolidayRental++;
	}
}

function ParameterGet( $sParamName, $sDefault ) {
	if( isset( $_POST[$sParamName] ) && is_string( $_POST[$sParamName] ) && mb_detect_encoding( $_POST[$sParamName], 'UTF-8', true ) ) {
		if( mb_strlen($_POST[$sParamName])>=1 ) {
			return $_POST[$sParamName];
		}
	} else if( isset( $_GET[$sParamName] ) && is_string( $_GET[$sParamName] ) && mb_detect_encoding( $_GET[$sParamName], 'UTF-8', true ) ) {
		if( mb_strlen($_GET[$sParamName])>=1 ) {
			return $_GET[$sParamName];
		}
	}
	if( isset( $sDefault) ) {
		return $sDefault;
	}
	return null;
}


//DebugTime(  1, 0 ); DebugTime(  1, 1 ); DebugTime(  1, 2 ); DebugTime(  1, 3 ); DebugTime(  1, 4 ); DebugTime(  1, 24 ); DebugTime( 31, 0 ); DebugTime( 31, 1 ); DebugTime( 31, 2 ); DebugTime( 31, 3 ); DebugTime( 31, 4 ); DebugTime( 31, 24 ); DebugTime( 51, 0 ); DebugTime( 51, 1 ); DebugTime( 51, 2 ); DebugTime( 51, 3 ); DebugTime( 51, 4 ); DebugTime( 51, 24 ); die();



//================================================================================//
//== Config Setup
//================================================================================//

//-- Set the Failsafe Config --//
$mConfig = array( 'bDebugging'=>false );
//-- Load the Global Config --//
require_once( SITE_BASE."/_Config.php" );




//================================================================================//
//== Setup
//================================================================================//
$bUseMap         = true;
$aReturn         = array();
$oXMLParser      = new REAXML_Manager( $mConfig );
$bOutputDebugLog = true;

//-- Add Estimated Times --//
$oDateTimezone   = new DateTimeZone('Australia/Brisbane');
$oDateTime       = new \DateTime('now', $oDateTimezone );
$sMinuteCurrent  = $oDateTime->format('i');
$iMinuteCurrent  = intval( $sMinuteCurrent );

//--------------------------------------------------------//
//-- Lookup Required Parameters
//--------------------------------------------------------//
//if( isset( $_POST['Mode'] ) && is_string( $_POST['Mode'] ) && mb_detect_encoding( $_POST['Mode'], 'UTF-8', true ) && mb_strlen($_POST['Mode'])>=2 ) {
//	$sMode = $_POST['Mode'];
//} else if( isset( $_GET['Mode'] ) && is_string( $_GET['Mode'] ) && mb_detect_encoding( $_GET['Mode'], 'UTF-8', true ) && mb_strlen($_GET['Mode'])>=2 ) {
//	$sMode = $_GET['Mode'];
//}
$sMode = ParameterGet( 'Mode', "QueueLookup" );






//================================================================================//
//== If Mode is ArchiveLookup
//================================================================================//
if( $sMode==="ArchiveLookup" ) {
	$aArchiveQueue = $oXMLParser->ListNestedLookupArchive( "All" );
	$aReturn = $aArchiveQueue;


//================================================================================//
//== ElseIf Mode is ArchiveDuplicateInputs
//================================================================================//
} else if( $sMode==="ArchiveDuplicateInputs" ) {
	$sReadOnly = ParameterGet('ReadOnly', "true" );
	$bReadOnly = true;
	if( $sReadOnly===null || $sReadOnly===false || $sReadOnly==="0" || strtolower($sReadOnly)==="false"  ) {
		$bReadOnly = false;
	}
	$bRemoveDuplicates = !$bReadOnly;
	//var_dump( $sReadOnly ); echo "<br />"; var_dump( $bReadOnly ); echo "<br />"; var_dump( $bRemoveDuplicates ); die();
	$aReturn = $oXMLParser->ArchiveDuplicateInputs( $bRemoveDuplicates );
	//$aReturn       = $aArchiveQueue;

//================================================================================//
//== ElseIf Mode is QueueLookup
//================================================================================//
} else if( $sMode==="QueueLookup" ) {
	//--------------------------------------------------------//
	//-- Declare and Setup Variables
	//--------------------------------------------------------//
	$iHourRes1    = 0;
	$iHourRes2    = 0;
	$iHourRes3    = 0;
	$iHourLand    = 0;
	$iHourComm    = 0;
	$iHourRent    = 0;
	$iHourRura    = 0;
	$iHourComL    = 0;
	$iHourHolR    = 0;
	$bResi        = false;
	$bLand        = false;
	$bComm        = false;
	$bRent        = false;
	$iLoopCount1  = 0;
	$iLoopCount2  = 0;
	$iLoopLimit   = 20000;
	$bContinue    = true;

	//--------------------------------------------------------//
	//-- Load the Import Queue and Process it
	//--------------------------------------------------------//
	$aImportQueue   = $oXMLParser->LookupListInputQueue( "All", $bUseMap );

	//----------------------------------------//
	//-- Process queue based on Current Time
	//----------------------------------------//
	//-- Does the first step
	if( $iMinuteCurrent>=1 && $iMinuteCurrent<11 ) {
		RunImport_Resi( $aReturn, $aImportQueue, $bResi, $iHourRes2, REAXML_Manager::START_MIN_RES2 );
		RunImport_Resi( $aReturn, $aImportQueue, $bResi, $iHourRes3, REAXML_Manager::START_MIN_RES3 );
		RunImport_Comm( $aReturn, $aImportQueue, $bComm, $iHourComm );
		RunImport_Land( $aReturn, $aImportQueue, $bLand, $iHourLand );
		RunImport_Rent( $aReturn, $aImportQueue, $bRent, $iHourRent );
	} else if( $iMinuteCurrent>=11 && $iMinuteCurrent<21 ) {
		RunImport_Resi( $aReturn, $aImportQueue, $bResi, $iHourRes3, REAXML_Manager::START_MIN_RES3 );
		RunImport_Comm( $aReturn, $aImportQueue, $bComm, $iHourComm );
		RunImport_Land( $aReturn, $aImportQueue, $bLand, $iHourLand );
		RunImport_Rent( $aReturn, $aImportQueue, $bRent, $iHourRent );
	} else if( $iMinuteCurrent>=21 && $iMinuteCurrent<31 ) {
		RunImport_Comm( $aReturn, $aImportQueue, $bComm, $iHourComm );
		RunImport_Land( $aReturn, $aImportQueue, $bLand, $iHourLand );
		RunImport_Rent( $aReturn, $aImportQueue, $bRent, $iHourRent );
	} else if( $iMinuteCurrent>=31 && $iMinuteCurrent<41 ) {
		RunImport_Land( $aReturn, $aImportQueue, $bLand, $iHourLand );
		RunImport_Rent( $aReturn, $aImportQueue, $bRent, $iHourRent );
	} else if( $iMinuteCurrent>=41 && $iMinuteCurrent<51 ) {
		RunImport_Rent( $aReturn, $aImportQueue, $bRent, $iHourRent );
	}


	//----------------------------------------//
	//-- Process queue normally
	//----------------------------------------//
	while( $bContinue===true && $iLoopCount1<$iLoopLimit ) {
		//-- Reset Variables --//
		$bResi = false;
		$bLand = false;
		$bComm = false;
		$bRent = false;

		//----------------------------------------//
		//-- Run Checks
		//----------------------------------------//
		RunImport_Resi( $aReturn, $aImportQueue, $bResi, $iHourRes1, REAXML_Manager::START_MIN_RES1 );
		RunImport_Resi( $aReturn, $aImportQueue, $bResi, $iHourRes2, REAXML_Manager::START_MIN_RES2 );
		RunImport_Resi( $aReturn, $aImportQueue, $bResi, $iHourRes3, REAXML_Manager::START_MIN_RES3 );
		RunImport_Comm( $aReturn, $aImportQueue, $bComm, $iHourComm );
		RunImport_Land( $aReturn, $aImportQueue, $bLand, $iHourLand );
		RunImport_Rent( $aReturn, $aImportQueue, $bRent, $iHourRent );


		//----------------------------------------//
		//-- End Loop Checks
		//----------------------------------------//
		if( $bResi===false && $bLand===false && $bComm===false && $bRent===false ) {
			$bContinue = false;
		}

		$iLoopCount1++;
	}    //-- EndWhile --//

	//----------------------------------------//
	//-- Process queue non-supported
	//----------------------------------------//
	$bContinue = true;
	while( $bContinue===true && $iLoopCount2<$iLoopLimit ) {
		//-- Reset Variables --//
		$bRura = false;
		$bComL = false;
		$bHolR = false;
		//-- Run Checks --//
		RunImport_Rura( $aReturn, $aImportQueue, $bRura, $iHourRura );
		RunImport_ComL( $aReturn, $aImportQueue, $bComL, $iHourComL );
		RunImport_HolR( $aReturn, $aImportQueue, $bHolR, $iHourHolR );
		//-- End Loop Checks --//
		if( $bRura===false && $bComL===false && $bHolR===false ) {
			$bContinue = false;
		}

		$iLoopCount2++;
	}    //-- EndWhile Process unsupported queue entries --//
}    //-- EndIf API Mode is QueueLookup --//




header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
$bAPIReturnEmpty = count( $aReturn ) >=1;
$mAPIReturn  = array( "Error"=>false, "Empty"=>$bAPIReturnEmpty, "Data"=>$aReturn );
if( $oXMLParser->LogDebugEnabled()===true ) {
	$mAPIReturn['DebugLogs'] = $oXMLParser->LogDebugListFetch();
}

echo json_encode( $mAPIReturn );
